
{******************************************************************************}
{                                                                              }
{                           Delphi XML Data Binding                            }
{                                                                              }
{         Generated on: 11/12/2001 5:02:43 PM                                  }
{       Generated from: C:\Keith\Delphi 6\Projects\XMLBind\movie-watcher.dtd   }
{   Settings stored in: C:\Keith\Delphi 6\Projects\XMLBind\movie-watcher.xdb   }
{                                                                              }
{******************************************************************************}
unit DataBindingObjs;

interface

uses xmldom, XMLDoc, XMLIntf, SysUtils, Windows, Variants;

type

{ Forward Decls }

  IXMLMovieWatcherType = interface;
  IXMLMoviesType = interface;
  IXMLMovieType = interface;
  IXMLStarringType = interface;
  IXMLCinemasType = interface;
  IXMLCinemaType = interface;
  IXMLFacilitiesType = interface;
  IXMLPricingType = interface;
  IXMLPricesType = interface;
  IXMLScreeningsType = interface;
  IXMLScreeningType = interface;
  IXMLFeaturesType = interface;
  IXMLRestrictionsType = interface;
  IXMLSessionsType = interface;
  IXMLSessionType = interface;

{ IXMLMovieWatcherType }

  IXMLMovieWatcherType = interface(IXMLNode)
    ['{A9970C67-FC5A-422A-8932-8F88BBFAD054}']
    { Property Accessors }
    function GetMovies: IXMLMoviesType;
    function GetCinemas: IXMLCinemasType;
    function GetScreenings: IXMLScreeningsType;
    { Methods & Properties }
    property Movies: IXMLMoviesType read GetMovies;
    property Cinemas: IXMLCinemasType read GetCinemas;
    property Screenings: IXMLScreeningsType read GetScreenings;
  end;

{ IXMLMoviesType }

  IXMLMoviesType = interface(IXMLNodeCollection)
    ['{DFD46023-2D28-4E62-AC86-C554FF283B5A}']
    { Property Accessors }
    function GetMovie(Index: Integer): IXMLMovieType;
    { Methods & Properties }
    function Add: IXMLMovieType;
    function Insert(const Index: Integer): IXMLMovieType;
    property Movie[Index: Integer]: IXMLMovieType read GetMovie; default;
  end;

{ IXMLMovieType }

  IXMLMovieType = interface(IXMLNode)
    ['{2A39E069-3EA2-4144-B3A8-1CBF6157E23E}']
    { Property Accessors }
    function GetId: WideString;
    function GetRating: WideString;
    function GetLogoUrl: WideString;
    function GetUrl: WideString;
    function GetName: WideString;
    function GetLength: Integer;
    function GetDirector: WideString;
    function GetStarring: IXMLStarringType;
    function GetSynopsis: WideString;
    procedure SetId(Value: WideString);
    procedure SetRating(Value: WideString);
    procedure SetLogoUrl(Value: WideString);
    procedure SetUrl(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetLength(Value: Integer);
    procedure SetDirector(Value: WideString);
    procedure SetSynopsis(Value: WideString);
    { Methods & Properties }
    property Id: WideString read GetId write SetId;
    property Rating: WideString read GetRating write SetRating;
    property LogoUrl: WideString read GetLogoUrl write SetLogoUrl;
    property Url: WideString read GetUrl write SetUrl;
    property Name: WideString read GetName write SetName;
    property Length: Integer read GetLength write SetLength;
    property Director: WideString read GetDirector write SetDirector;
    property Starring: IXMLStarringType read GetStarring;
    property Synopsis: WideString read GetSynopsis write SetSynopsis;
  end;

{ IXMLStarringType }

  IXMLStarringType = interface(IXMLNodeCollection)
    ['{4E487310-74B5-4B6B-BE64-D66C4A537998}']
    { Property Accessors }
    function GetStar(Index: Integer): WideString;
    { Methods & Properties }
    function Add(const Star: WideString): IXMLNode;
    function Insert(const Index: Integer; const Star: WideString): IXMLNode;
    property Star[Index: Integer]: WideString read GetStar; default;
  end;

{ IXMLCinemasType }

  IXMLCinemasType = interface(IXMLNodeCollection)
    ['{0EEDEB72-AAC0-4B69-AF1F-7676450172E8}']
    { Property Accessors }
    function GetCinema(Index: Integer): IXMLCinemaType;
    { Methods & Properties }
    function Add: IXMLCinemaType;
    function Insert(const Index: Integer): IXMLCinemaType;
    property Cinema[Index: Integer]: IXMLCinemaType read GetCinema; default;
  end;

{ IXMLCinemaType }

  IXMLCinemaType = interface(IXMLNode)
    ['{30960EC0-A982-4025-B7FA-6BC579D87629}']
    { Property Accessors }
    function GetId: WideString;
    function GetLogoUrl: WideString;
    function GetUrl: WideString;
    function GetName: WideString;
    function GetPhone: WideString;
    function GetAddress: WideString;
    function GetDirections: WideString;
    function GetFacilities: IXMLFacilitiesType;
    function GetPricing: IXMLPricingType;
    procedure SetId(Value: WideString);
    procedure SetLogoUrl(Value: WideString);
    procedure SetUrl(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetPhone(Value: WideString);
    procedure SetAddress(Value: WideString);
    procedure SetDirections(Value: WideString);
    { Methods & Properties }
    property Id: WideString read GetId write SetId;
    property LogoUrl: WideString read GetLogoUrl write SetLogoUrl;
    property Url: WideString read GetUrl write SetUrl;
    property Name: WideString read GetName write SetName;
    property Phone: WideString read GetPhone write SetPhone;
    property Address: WideString read GetAddress write SetAddress;
    property Directions: WideString read GetDirections write SetDirections;
    property Facilities: IXMLFacilitiesType read GetFacilities;
    property Pricing: IXMLPricingType read GetPricing;
  end;

{ IXMLFacilitiesType }

  IXMLFacilitiesType = interface(IXMLNode)
    ['{BCD217BD-502F-4317-B6AF-8F8EDA200403}']
    { Property Accessors }
    function GetCandyBar: Boolean;
    function GetDisabledAccess: Boolean;
    procedure SetCandyBar(Value: Boolean);
    procedure SetDisabledAccess(Value: Boolean);
    { Methods & Properties }
    property CandyBar: Boolean read GetCandyBar write SetCandyBar;
    property DisabledAccess: Boolean read GetDisabledAccess write SetDisabledAccess;
  end;

{ IXMLPricingType }

  IXMLPricingType = interface(IXMLNodeCollection)
    ['{7977DB78-E235-4541-A521-9A446A12A9C6}']
    { Property Accessors }
    function GetPrices(Index: Integer): IXMLPricesType;
    { Methods & Properties }
    function Add: IXMLPricesType;
    function Insert(const Index: Integer): IXMLPricesType;
    property Prices[Index: Integer]: IXMLPricesType read GetPrices; default;
  end;

{ IXMLPricesType }

  IXMLPricesType = interface(IXMLNode)
    ['{9AF77FB0-EF44-4FC6-AB87-538036CC4E6D}']
    { Property Accessors }
    function GetId: WideString;
    function GetName: WideString;
    function GetPeriod: WideString;
    function GetAdult: Double;
    function GetChild: Double;
    function GetDiscount: Double;
    procedure SetId(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetPeriod(Value: WideString);
    procedure SetAdult(Value: Double);
    procedure SetChild(Value: Double);
    procedure SetDiscount(Value: Double);
    { Methods & Properties }
    property Id: WideString read GetId write SetId;
    property Name: WideString read GetName write SetName;
    property Period: WideString read GetPeriod write SetPeriod;
    property Adult: Double read GetAdult write SetAdult;
    property Child: Double read GetChild write SetChild;
    property Discount: Double read GetDiscount write SetDiscount;
  end;

{ IXMLScreeningsType }

  IXMLScreeningsType = interface(IXMLNodeCollection)
    ['{593FD30F-FF4E-4002-AC54-C7BAC6016FF9}']
    { Property Accessors }
    function GetScreening(Index: Integer): IXMLScreeningType;
    { Methods & Properties }
    function Add: IXMLScreeningType;
    function Insert(const Index: Integer): IXMLScreeningType;
    property Screening[Index: Integer]: IXMLScreeningType read GetScreening; default;
  end;

{ IXMLScreeningType }

  IXMLScreeningType = interface(IXMLNode)
    ['{6FCD3E62-7086-45A2-B3C0-B0B6C116BA3D}']
    { Property Accessors }
    function GetMovieId: WideString;
    function GetCinemaId: WideString;
    function GetStartDate: TDateTime;
    function GetEndDate: TDateTime;
    function GetFeatures: IXMLFeaturesType;
    function GetRestrictions: IXMLRestrictionsType;
    function GetSessions: IXMLSessionsType;
    procedure SetMovieId(Value: WideString);
    procedure SetCinemaId(Value: WideString);
    procedure SetStartDate(Value: TDateTime);
    procedure SetEndDate(Value: TDateTime);
    { Methods & Properties }
    property MovieId: WideString read GetMovieId write SetMovieId;
    property CinemaId: WideString read GetCinemaId write SetCinemaId;
    property StartDate: TDateTime read GetStartDate write SetStartDate;
    property EndDate: TDateTime read GetEndDate write SetEndDate;
    property Features: IXMLFeaturesType read GetFeatures;
    property Restrictions: IXMLRestrictionsType read GetRestrictions;
    property Sessions: IXMLSessionsType read GetSessions;
  end;

{ IXMLFeaturesType }

  IXMLFeaturesType = interface(IXMLNode)
    ['{85A3180A-FC1F-40A6-8E4E-AE00550E46D4}']
    { Property Accessors }
    function GetDigitalSound: WideString;
    procedure SetDigitalSound(Value: WideString);
    { Methods & Properties }
    property DigitalSound: WideString read GetDigitalSound write SetDigitalSound;
  end;

{ IXMLRestrictionsType }

  IXMLRestrictionsType = interface(IXMLNode)
    ['{598EC223-4917-4569-8C53-59976E57A183}']
    { Property Accessors }
    function GetNoPasses: Boolean;
    procedure SetNoPasses(Value: Boolean);
    { Methods & Properties }
    property NoPasses: Boolean read GetNoPasses write SetNoPasses;
  end;

{ IXMLSessionsType }

  IXMLSessionsType = interface(IXMLNodeCollection)
    ['{C0FABFD5-802E-41EA-B14D-DA9E5D1A4744}']
    { Property Accessors }
    function GetSession(Index: Integer): IXMLSessionType;
    { Methods & Properties }
    function Add: IXMLSessionType;
    function Insert(const Index: Integer): IXMLSessionType;
    property Session[Index: Integer]: IXMLSessionType read GetSession; default;
  end;

{ IXMLSessionType }

  IXMLSessionType = interface(IXMLNode)
    ['{BE29F3DB-B000-4A4C-8329-293770AE7E3D}']
    { Property Accessors }
    function GetPriceId: WideString;
    procedure SetPriceId(Value: WideString);
    function GetTime: TDateTime;          // KW
    procedure SetTime(Value: TDateTime);  // KW
    { Methods & Properties }
    property PriceId: WideString read GetPriceId write SetPriceId;
    property Time: TDateTime read GetTime write SetTime;  // KW
  end;

{ Forward Decls }

  TXMLMovieWatcherType = class;
  TXMLMoviesType = class;
  TXMLMovieType = class;
  TXMLStarringType = class;
  TXMLCinemasType = class;
  TXMLCinemaType = class;
  TXMLFacilitiesType = class;
  TXMLPricingType = class;
  TXMLPricesType = class;
  TXMLScreeningsType = class;
  TXMLScreeningType = class;
  TXMLFeaturesType = class;
  TXMLRestrictionsType = class;
  TXMLSessionsType = class;
  TXMLSessionType = class;

{ TXMLMovieWatcherType }

  TXMLMovieWatcherType = class(TXMLNode, IXMLMovieWatcherType)
  protected
    { IXMLMovieWatcherType }
    function GetMovies: IXMLMoviesType;
    function GetCinemas: IXMLCinemasType;
    function GetScreenings: IXMLScreeningsType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLMoviesType }

  TXMLMoviesType = class(TXMLNodeCollection, IXMLMoviesType)
  protected
    { IXMLMoviesType }
    function GetMovie(Index: Integer): IXMLMovieType;
    function Add: IXMLMovieType;
    function Insert(const Index: Integer): IXMLMovieType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLMovieType }

  TXMLMovieType = class(TXMLNode, IXMLMovieType)
  protected
    { IXMLMovieType }
    function GetId: WideString;
    function GetRating: WideString;
    function GetLogoUrl: WideString;
    function GetUrl: WideString;
    function GetName: WideString;
    function GetLength: Integer;
    function GetDirector: WideString;
    function GetStarring: IXMLStarringType;
    function GetSynopsis: WideString;
    procedure SetId(Value: WideString);
    procedure SetRating(Value: WideString);
    procedure SetLogoUrl(Value: WideString);
    procedure SetUrl(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetLength(Value: Integer);
    procedure SetDirector(Value: WideString);
    procedure SetSynopsis(Value: WideString);
  public
    procedure AfterConstruction; override;
  end;

{ TXMLStarringType }

  TXMLStarringType = class(TXMLNodeCollection, IXMLStarringType)
  protected
    { IXMLStarringType }
    function GetStar(Index: Integer): WideString;
    function Add(const Star: WideString): IXMLNode;
    function Insert(const Index: Integer; const Star: WideString): IXMLNode;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLCinemasType }

  TXMLCinemasType = class(TXMLNodeCollection, IXMLCinemasType)
  protected
    { IXMLCinemasType }
    function GetCinema(Index: Integer): IXMLCinemaType;
    function Add: IXMLCinemaType;
    function Insert(const Index: Integer): IXMLCinemaType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLCinemaType }

  TXMLCinemaType = class(TXMLNode, IXMLCinemaType)
  protected
    { IXMLCinemaType }
    function GetId: WideString;
    function GetLogoUrl: WideString;
    function GetUrl: WideString;
    function GetName: WideString;
    function GetPhone: WideString;
    function GetAddress: WideString;
    function GetDirections: WideString;
    function GetFacilities: IXMLFacilitiesType;
    function GetPricing: IXMLPricingType;
    procedure SetId(Value: WideString);
    procedure SetLogoUrl(Value: WideString);
    procedure SetUrl(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetPhone(Value: WideString);
    procedure SetAddress(Value: WideString);
    procedure SetDirections(Value: WideString);
  public
    procedure AfterConstruction; override;
  end;

{ TXMLFacilitiesType }

  TXMLFacilitiesType = class(TXMLNode, IXMLFacilitiesType)
  protected
    { IXMLFacilitiesType }
    function GetCandyBar: Boolean;
    function GetDisabledAccess: Boolean;
    procedure SetCandyBar(Value: Boolean);
    procedure SetDisabledAccess(Value: Boolean);
  end;

{ TXMLPricingType }

  TXMLPricingType = class(TXMLNodeCollection, IXMLPricingType)
  protected
    { IXMLPricingType }
    function GetPrices(Index: Integer): IXMLPricesType;
    function Add: IXMLPricesType;
    function Insert(const Index: Integer): IXMLPricesType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLPricesType }

  TXMLPricesType = class(TXMLNode, IXMLPricesType)
  protected
    { IXMLPricesType }
    function GetId: WideString;
    function GetName: WideString;
    function GetPeriod: WideString;
    function GetAdult: Double;
    function GetChild: Double;
    function GetDiscount: Double;
    procedure SetId(Value: WideString);
    procedure SetName(Value: WideString);
    procedure SetPeriod(Value: WideString);
    procedure SetAdult(Value: Double);
    procedure SetChild(Value: Double);
    procedure SetDiscount(Value: Double);
  end;

{ TXMLScreeningsType }

  TXMLScreeningsType = class(TXMLNodeCollection, IXMLScreeningsType)
  protected
    { IXMLScreeningsType }
    function GetScreening(Index: Integer): IXMLScreeningType;
    function Add: IXMLScreeningType;
    function Insert(const Index: Integer): IXMLScreeningType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLScreeningType }

  TXMLScreeningType = class(TXMLNode, IXMLScreeningType)
  protected
    { IXMLScreeningType }
    function GetMovieId: WideString;
    function GetCinemaId: WideString;
    function GetStartDate: TDateTime;
    function GetEndDate: TDateTime;
    function GetFeatures: IXMLFeaturesType;
    function GetRestrictions: IXMLRestrictionsType;
    function GetSessions: IXMLSessionsType;
    procedure SetMovieId(Value: WideString);
    procedure SetCinemaId(Value: WideString);
    procedure SetStartDate(Value: TDateTime);
    procedure SetEndDate(Value: TDateTime);
  public
    procedure AfterConstruction; override;
  end;

{ TXMLFeaturesType }

  TXMLFeaturesType = class(TXMLNode, IXMLFeaturesType)
  protected
    { IXMLFeaturesType }
    function GetDigitalSound: WideString;
    procedure SetDigitalSound(Value: WideString);
  end;

{ TXMLRestrictionsType }

  TXMLRestrictionsType = class(TXMLNode, IXMLRestrictionsType)
  protected
    { IXMLRestrictionsType }
    function GetNoPasses: Boolean;
    procedure SetNoPasses(Value: Boolean);
  end;

{ TXMLSessionsType }

  TXMLSessionsType = class(TXMLNodeCollection, IXMLSessionsType)
  protected
    { IXMLSessionsType }
    function GetSession(Index: Integer): IXMLSessionType;
    function Add: IXMLSessionType;
    function Insert(const Index: Integer): IXMLSessionType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLSessionType }

  TXMLSessionType = class(TXMLNode, IXMLSessionType)
  protected
    { IXMLSessionType }
    function GetPriceId: WideString;
    procedure SetPriceId(Value: WideString);
    function GetTime: TDateTime;          // KW
    procedure SetTime(Value: TDateTime);  // KW
  end;

{ Global Functions }

function GetMovieWatcher(Doc: IXMLDocument): IXMLMovieWatcherType;
function LoadMovieWatcher(const FileName: WideString): IXMLMovieWatcherType;
function NewMovieWatcher: IXMLMovieWatcherType;

implementation

{ Global Functions }

function GetMovieWatcher(Doc: IXMLDocument): IXMLMovieWatcherType;
begin
  Result := Doc.GetDocBinding('movie-watcher', TXMLMovieWatcherType) as IXMLMovieWatcherType;
end;

function LoadMovieWatcher(const FileName: WideString): IXMLMovieWatcherType;
begin
  Result := LoadXMLDocument(FileName).GetDocBinding('movie-watcher', TXMLMovieWatcherType) as IXMLMovieWatcherType;
end;

function NewMovieWatcher: IXMLMovieWatcherType;
begin
  Result := NewXMLDocument.GetDocBinding('movie-watcher', TXMLMovieWatcherType) as IXMLMovieWatcherType;
end;

{ TXMLMovieWatcherType }

procedure TXMLMovieWatcherType.AfterConstruction;
begin
  RegisterChildNode('movies', TXMLMoviesType);
  RegisterChildNode('cinemas', TXMLCinemasType);
  RegisterChildNode('screenings', TXMLScreeningsType);
  inherited;
end;

function TXMLMovieWatcherType.GetMovies: IXMLMoviesType;
begin
  Result := ChildNodes['movies'] as IXMLMoviesType;
end;

function TXMLMovieWatcherType.GetCinemas: IXMLCinemasType;
begin
  Result := ChildNodes['cinemas'] as IXMLCinemasType;
end;

function TXMLMovieWatcherType.GetScreenings: IXMLScreeningsType;
begin
  Result := ChildNodes['screenings'] as IXMLScreeningsType;
end;

{ TXMLMoviesType }

procedure TXMLMoviesType.AfterConstruction;
begin
  RegisterChildNode('movie', TXMLMovieType);
  ItemTag := 'movie';
  ItemInterface := IXMLMovieType;
  inherited;
end;

function TXMLMoviesType.GetMovie(Index: Integer): IXMLMovieType;
begin
  Result := List[Index] as IXMLMovieType;
end;

function TXMLMoviesType.Add: IXMLMovieType;
begin
  Result := AddItem(-1) as IXMLMovieType;
end;

function TXMLMoviesType.Insert(const Index: Integer): IXMLMovieType;
begin
  Result := AddItem(Index) as IXMLMovieType;
end;


{ TXMLMovieType }

procedure TXMLMovieType.AfterConstruction;
begin
  RegisterChildNode('starring', TXMLStarringType);
  inherited;
end;

function TXMLMovieType.GetId: WideString;
begin
  Result := AttributeNodes['id'].Text;
end;

procedure TXMLMovieType.SetId(Value: WideString);
begin
  SetAttribute('id', Value);
end;

function TXMLMovieType.GetRating: WideString;
begin
  Result := AttributeNodes['rating'].Text;
end;

procedure TXMLMovieType.SetRating(Value: WideString);
begin
  SetAttribute('rating', Value);
end;

function TXMLMovieType.GetLogoUrl: WideString;
begin
  Result := AttributeNodes['logo-url'].Text;
end;

procedure TXMLMovieType.SetLogoUrl(Value: WideString);
begin
  SetAttribute('logo-url', Value);
end;

function TXMLMovieType.GetUrl: WideString;
begin
  Result := AttributeNodes['url'].Text;
end;

procedure TXMLMovieType.SetUrl(Value: WideString);
begin
  SetAttribute('url', Value);
end;

function TXMLMovieType.GetName: WideString;
begin
  Result := ChildNodes['name'].Text;
end;

procedure TXMLMovieType.SetName(Value: WideString);
begin
  ChildNodes['name'].NodeValue := Value;
end;

function TXMLMovieType.GetLength: Integer;
begin
  Result := ChildNodes['length'].NodeValue;
end;

procedure TXMLMovieType.SetLength(Value: Integer);
begin
  ChildNodes['length'].NodeValue := Value;
end;

function TXMLMovieType.GetDirector: WideString;
begin
  Result := ChildNodes['director'].Text;
end;

procedure TXMLMovieType.SetDirector(Value: WideString);
begin
  ChildNodes['director'].NodeValue := Value;
end;

function TXMLMovieType.GetStarring: IXMLStarringType;
begin
  Result := ChildNodes['starring'] as IXMLStarringType;
end;

function TXMLMovieType.GetSynopsis: WideString;
begin
  Result := ChildNodes['synopsis'].Text;
end;

procedure TXMLMovieType.SetSynopsis(Value: WideString);
begin
  ChildNodes['synopsis'].NodeValue := Value;
end;

{ TXMLStarringType }

procedure TXMLStarringType.AfterConstruction;
begin
  ItemTag := 'star';
  ItemInterface := IXMLNode;
  inherited;
end;

function TXMLStarringType.GetStar(Index: Integer): WideString;
begin
  Result := ChildNodes[Index].Text;  // KW
end;

function TXMLStarringType.Add(const Star: WideString): IXMLNode;
begin
  Result := AddItem(-1);
  Result.NodeValue := Star;
end;


function TXMLStarringType.Insert(const Index: Integer; const Star: WideString): IXMLNode;
begin
  Result := AddItem(Index);
  Result.NodeValue := Star;
end;



{ TXMLCinemasType }

procedure TXMLCinemasType.AfterConstruction;
begin
  RegisterChildNode('cinema', TXMLCinemaType);
  ItemTag := 'cinema';
  ItemInterface := IXMLCinemaType;
  inherited;
end;

function TXMLCinemasType.GetCinema(Index: Integer): IXMLCinemaType;
begin
  Result := List[Index] as IXMLCinemaType;
end;

function TXMLCinemasType.Add: IXMLCinemaType;
begin
  Result := AddItem(-1) as IXMLCinemaType;
end;

function TXMLCinemasType.Insert(const Index: Integer): IXMLCinemaType;
begin
  Result := AddItem(Index) as IXMLCinemaType;
end;


{ TXMLCinemaType }

procedure TXMLCinemaType.AfterConstruction;
begin
  RegisterChildNode('facilities', TXMLFacilitiesType);
  RegisterChildNode('pricing', TXMLPricingType);
  inherited;
end;

function TXMLCinemaType.GetId: WideString;
begin
  Result := AttributeNodes['id'].Text;
end;

procedure TXMLCinemaType.SetId(Value: WideString);
begin
  SetAttribute('id', Value);
end;

function TXMLCinemaType.GetLogoUrl: WideString;
begin
  Result := AttributeNodes['logo-url'].Text;
end;

procedure TXMLCinemaType.SetLogoUrl(Value: WideString);
begin
  SetAttribute('logo-url', Value);
end;

function TXMLCinemaType.GetUrl: WideString;
begin
  Result := AttributeNodes['url'].Text;
end;

procedure TXMLCinemaType.SetUrl(Value: WideString);
begin
  SetAttribute('url', Value);
end;

function TXMLCinemaType.GetName: WideString;
begin
  Result := ChildNodes['name'].Text;
end;

procedure TXMLCinemaType.SetName(Value: WideString);
begin
  ChildNodes['name'].NodeValue := Value;
end;

function TXMLCinemaType.GetPhone: WideString;
begin
  Result := ChildNodes['phone'].Text;
end;

procedure TXMLCinemaType.SetPhone(Value: WideString);
begin
  ChildNodes['phone'].NodeValue := Value;
end;

function TXMLCinemaType.GetAddress: WideString;

  function AddText(Node: IXMLNode): WideString;  // KW
  var
    Index: Integer;
  begin
    if (Node.NodeType in [ntText, ntCData]) then
      Result := Result + Node.NodeValue;
    for Index := 0 to Node.ChildNodes.Count - 1 do
      Result := Result + AddText(Node.ChildNodes.Get(Index));
  end;

begin
  Result := AddText(ChildNodes['address']);  // KW
end;

procedure TXMLCinemaType.SetAddress(Value: WideString);
begin
  ChildNodes['address'].Text := Value;
end;

function TXMLCinemaType.GetDirections: WideString;
begin
  Result := ChildNodes['directions'].Text;
end;

procedure TXMLCinemaType.SetDirections(Value: WideString);
begin
  ChildNodes['directions'].NodeValue := Value;
end;

function TXMLCinemaType.GetFacilities: IXMLFacilitiesType;
begin
  Result := ChildNodes['facilities'] as IXMLFacilitiesType;
end;

function TXMLCinemaType.GetPricing: IXMLPricingType;
begin
  Result := ChildNodes['pricing'] as IXMLPricingType;
end;

{ TXMLFacilitiesType }

function TXMLFacilitiesType.GetCandyBar: Boolean;
begin
  Result := Assigned(ChildNodes.FindNode('candy-bar'));  // KW
end;

procedure TXMLFacilitiesType.SetCandyBar(Value: Boolean);
begin
  if Value then  // KW
  begin
    if not GetCandyBar then
      AddChild('candy-bar');
  end
  else
    ChildNodes.Delete('candy-bar');
end;

function TXMLFacilitiesType.GetDisabledAccess: Boolean;
begin
  Result := Assigned(ChildNodes.FindNode('disabled-access'));  // KW
end;

procedure TXMLFacilitiesType.SetDisabledAccess(Value: Boolean);
begin
  if Value then  // KW
  begin
    if not GetDisabledAccess then
      AddChild('disabled-access');
  end
  else
    ChildNodes.Delete('disabled-access');
end;

{ TXMLPricingType }

procedure TXMLPricingType.AfterConstruction;
begin
  RegisterChildNode('prices', TXMLPricesType);
  ItemTag := 'prices';
  ItemInterface := IXMLPricesType;
  inherited;
end;

function TXMLPricingType.GetPrices(Index: Integer): IXMLPricesType;
begin
  Result := List[Index] as IXMLPricesType;
end;

function TXMLPricingType.Add: IXMLPricesType;
begin
  Result := AddItem(-1) as IXMLPricesType;
end;

function TXMLPricingType.Insert(const Index: Integer): IXMLPricesType;
begin
  Result := AddItem(Index) as IXMLPricesType;
end;


{ TXMLPricesType }

function TXMLPricesType.GetId: WideString;
begin
  Result := AttributeNodes['id'].Text;
end;

procedure TXMLPricesType.SetId(Value: WideString);
begin
  SetAttribute('id', Value);
end;

function TXMLPricesType.GetName: WideString;
begin
  Result := ChildNodes['name'].Text;
end;

procedure TXMLPricesType.SetName(Value: WideString);
begin
  ChildNodes['name'].NodeValue := Value;
end;

function TXMLPricesType.GetPeriod: WideString;
begin
  Result := ChildNodes['period'].Text;
end;

procedure TXMLPricesType.SetPeriod(Value: WideString);
begin
  ChildNodes['period'].NodeValue := Value;
end;

function TXMLPricesType.GetAdult: Double;
begin
  Result := ChildNodes['adult'].NodeValue;
end;

procedure TXMLPricesType.SetAdult(Value: Double);
begin
  ChildNodes['adult'].NodeValue := Value;
end;

function TXMLPricesType.GetChild: Double;
begin
  Result := ChildNodes['child'].NodeValue;
end;

procedure TXMLPricesType.SetChild(Value: Double);
begin
  ChildNodes['child'].NodeValue := Value;
end;

function TXMLPricesType.GetDiscount: Double;
var
  Value: OleVariant;
begin
  Value := ChildNodes['discount'].NodeValue;
  if VarIsNull(Value) then  // KW
    Result := 0.00
  else
    Result := Value;
end;

procedure TXMLPricesType.SetDiscount(Value: Double);
begin
  if Value <> 0.00 then  // KW
    ChildNodes['discount'].NodeValue := Value
  else
    ChildNodes.Delete('discount');
end;

{ TXMLScreeningsType }

procedure TXMLScreeningsType.AfterConstruction;
begin
  RegisterChildNode('screening', TXMLScreeningType);
  ItemTag := 'screening';
  ItemInterface := IXMLScreeningType;
  inherited;
end;

function TXMLScreeningsType.GetScreening(Index: Integer): IXMLScreeningType;
begin
  Result := List[Index] as IXMLScreeningType;
end;

function TXMLScreeningsType.Add: IXMLScreeningType;
begin
  Result := AddItem(-1) as IXMLScreeningType;
end;

function TXMLScreeningsType.Insert(const Index: Integer): IXMLScreeningType;
begin
  Result := AddItem(Index) as IXMLScreeningType;
end;


{ TXMLScreeningType }

procedure TXMLScreeningType.AfterConstruction;
begin
  RegisterChildNode('features', TXMLFeaturesType);
  RegisterChildNode('restrictions', TXMLRestrictionsType);
  RegisterChildNode('sessions', TXMLSessionsType);
  inherited;
end;

function TXMLScreeningType.GetMovieId: WideString;
begin
  Result := AttributeNodes['movie-id'].Text;
end;

procedure TXMLScreeningType.SetMovieId(Value: WideString);
begin
  SetAttribute('movie-id', Value);
end;

function TXMLScreeningType.GetCinemaId: WideString;
begin
  Result := AttributeNodes['cinema-id'].Text;
end;

procedure TXMLScreeningType.SetCinemaId(Value: WideString);
begin
  SetAttribute('cinema-id', Value);
end;

function TXMLScreeningType.GetStartDate: TDateTime;
begin
  Result := StrToDate(ChildNodes['start-date'].NodeValue);  // KW
end;

procedure TXMLScreeningType.SetStartDate(Value: TDateTime);
begin
  ChildNodes['start-date'].NodeValue := DateToStr(Value);  // KW
end;

function TXMLScreeningType.GetEndDate: TDateTime;
begin
  Result := StrToDate(ChildNodes['end-date'].NodeValue);  // KW
end;

procedure TXMLScreeningType.SetEndDate(Value: TDateTime);
begin
  ChildNodes['end-date'].NodeValue := DateToStr(Value);  // KW
end;

function TXMLScreeningType.GetFeatures: IXMLFeaturesType;
begin
  Result := ChildNodes['features'] as IXMLFeaturesType;
end;

function TXMLScreeningType.GetRestrictions: IXMLRestrictionsType;
begin
  Result := ChildNodes['restrictions'] as IXMLRestrictionsType;
end;

function TXMLScreeningType.GetSessions: IXMLSessionsType;
begin
  Result := ChildNodes['sessions'] as IXMLSessionsType;
end;

{ TXMLFeaturesType }

function TXMLFeaturesType.GetDigitalSound: WideString;
begin
  Result := ChildNodes['digital-sound'].Text;
end;

procedure TXMLFeaturesType.SetDigitalSound(Value: WideString);
begin
  ChildNodes['digital-sound'].NodeValue := Value;
end;

{ TXMLRestrictionsType }

function TXMLRestrictionsType.GetNoPasses: Boolean;
begin
  Result := Assigned(ChildNodes.FindNode('no-passes'));  // KW
end;

procedure TXMLRestrictionsType.SetNoPasses(Value: Boolean);
begin
  if Value then  // KW
  begin
    if not GetNoPasses then
      AddChild('no-passes');
  end
  else
    ChildNodes.Delete('no-passes');
end;

{ TXMLSessionsType }

procedure TXMLSessionsType.AfterConstruction;
begin
  RegisterChildNode('session', TXMLSessionType);
  ItemTag := 'session';
  ItemInterface := IXMLSessionType;
  inherited;
end;

function TXMLSessionsType.GetSession(Index: Integer): IXMLSessionType;
begin
  Result := List[Index] as IXMLSessionType;
end;

function TXMLSessionsType.Add: IXMLSessionType;
begin
  Result := AddItem(-1) as IXMLSessionType;
end;

function TXMLSessionsType.Insert(const Index: Integer): IXMLSessionType;
begin
  Result := AddItem(Index) as IXMLSessionType;
end;


{ TXMLSessionType }

function TXMLSessionType.GetPriceId: WideString;
begin
  Result := AttributeNodes['price-id'].Text;
end;

procedure TXMLSessionType.SetPriceId(Value: WideString);
begin
  SetAttribute('price-id', Value);
end;

function TXMLSessionType.GetTime: TDateTime;  // KW
begin
  Result := StrToTime(GetText);
end;

procedure TXMLSessionType.SetTime(Value: TDateTime);  // KW
begin
  SetText(TimeToStr(Value));
end;

initialization
  ShortDateFormat := 'MM/dd/yyyy';  // XML is in US fomat
end.
